/*
 * Decompiled with CFR 0.152.
 */
package de.xyonox.voidles.worldMobGen;

import de.xyonox.voidles.entity.ModEntityTypes;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModEntityGeneration {
    public static void onEntitySpawn(BiomeLoadingEvent event) {
        ModEntityGeneration.addEntityToAllOverworldBiomes(event, (EntityType)ModEntityTypes.WITHER_DWARF.get(), 40, 2, 4);
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    @SafeVarargs
    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllOverworldBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.THEEND) && !event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) {
            ModEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomesNoNether(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) {
            List base = event.getSpawns().getSpawner(type.m_20674_());
            base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
        }
    }

    private static void addEntityToAllBiomesNoEnd(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.THEEND)) {
            List base = event.getSpawns().getSpawner(type.m_20674_());
            base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
        }
    }

    private static void addEntityToAllBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = event.getSpawns().getSpawner(type.m_20674_());
        base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
    }
}

